<?
require 'inc/functions.inc';

$facultyId = $_GET['id'];

if ($facultyId != 0) {
	foreach (FACULTIES as $faculty) {
		if ($faculty['id'] == $facultyId) {
			$facultyName = $faculty['name'];
			$facultyIcon = $faculty['icon'];
			break;
		}
	}
	if (!isset($facultyName)) redirect('login.php');

	$whereCriterion = ' WHERE facultyId=?';
	$params = [$facultyId, $facultyId];
	$students = getStudents($facultyId);

	define('WHOLE_INSTITUTION', false);
}
else {
	//The whole institution
	$facultyName = WHOLE_INSTITUTION_FACULTY['name'];
	$facultyIcon = WHOLE_INSTITUTION_FACULTY['icon'];

	$whereCriterion = '';
	$params = null;
	$students = STUDENTS;

	define('WHOLE_INSTITUTION', true);
}

$chartsData[$facultyId] = queryDB('SELECT CASE WHEN predictedP<=0.529 THEN "3 סיכון נמוך" WHEN predictedP<=0.551 THEN "2 סיכון בינוני" ELSE "1 סיכון גבוה" END AS riskGroup,
		ROUND(COUNT(0)/(SELECT COUNT(0) AS `count` FROM studentsData'.$whereCriterion.')*100,1) AS percentage
	FROM studentsData'.$whereCriterion.'
	GROUP BY riskGroup ORDER BY riskGroup', $params);
?>
<!DOCTYPE html>
<html>
<head>
	<? require 'inc/commonHead.inc'; ?>
	<title><?=htmlspecialchars($facultyName).' | '.APP_NAME?></title>
</head>

<body>
	<main class="main" id="top">
		<div class="container" data-layout="container">
			<? require 'inc/menu.inc'; ?>

			<div class="content">
				<? require 'inc/searchBar.inc'; ?>

				<div class="row mb-4">
					<div class="col-3 px-2">
						<div class="card">
							<div class="card-header">
								<span class="<?=$facultyIcon?>"></span> <?=htmlspecialchars($facultyName)?>
							</div>
							<div class="card-body overflow-hidden p-lg-4">
								<canvas id="chart<?=$facultyId?>"></canvas>
								<?
								foreach ($chartsData[$facultyId] as $chartData) {
									$riskGroup = substr($chartData['riskGroup'], 2);
									// TODO: set this with periodical data
									$change = '<span class="fas '.(rand(0,99) < 50 ? 'fa-caret-down text-danger' : 'fa-caret-up text-success').'"></span> '.rand(1,200).'%';

									echo '<div class="row border-top py-2'.($riskGroup == 'סיכון גבוה' ? ' mt-4' : ($riskGroup == 'סיכון נמוך' ? ' mb-n3' : '')).' cursor-pointer" onclick="filterStudentsList(\''.$riskGroup.'\')">
											<div class="col px-2">'.$riskGroup.'</div>
											<div class="col px-2">'.$chartData['percentage'].'%</div>
											<div class="col px-2">'.$change.'</div>
										</div>';
								}
								?>
						</div>
						</div>
					</div>
					<div class="col-7 px-2">
						<div class="card" data-list='{"valueNames":["name","id","predictedP"],"filter":true,"filterName":"predictedP"}'>
							<div class="card-header d-flex flex-between-center py-2">
								<h6 class="mb-0">רשימת הסטודנטים</h6>
								<div class="dropdown font-sans-serif btn-reveal-trigger">
									<button class="btn btn-link text-600 btn-sm dropdown-toggle dropdown-caret-none btn-reveal" type="button" id="recent-header-dropdownundefined" data-bs-toggle="dropdown" data-boundary="viewport" aria-haspopup="true" aria-expanded="false">
										<span class="fas fa-ellipsis-h fs--2"></span>
									</button>
									<div class="dropdown-menu dropdown-menu-end border py-2" aria-labelledby="recent-header-dropdownundefined">
										<a class="dropdown-item cursor-pointer" onclick="export2XL()">יצוא לאקסל</a>
									</div>
								</div>
							</div>
							<div class="card-body px-0 py-0">
								<div class="row justify-content-end g-0">
									<div class="col-auto px-3">
										<select id="statusList" class="form-select form-select-sm mb-3" aria-label="Bulk actions" data-list-filter="data-list-filter">
											<option value="" selected>בחר סטטוס לסינון</option>
											<option value="סיכון גבוה">סיכון גבוה</option>
											<option value="סיכון בינוני">סיכון בינוני</option>
											<option value="סיכון נמוך">סיכון נמוך</option>
										</select>
									</div>
								</div>
								<div class="table-responsive scrollbar">
									<form action="model/export.php" method="post" name="form">
										<table class="table fs--1 mb-0">
											<thead class="bg-200 text-800"><tr>
												<th class="py-3 white-space-nowrap" style="max-width:30px">
													<div class="form-check mb-0 d-flex align-items-center">
														<input class="form-check-input" id="checkbox-bulk-select" type="checkbox" data-bulk-select='{"body":"table-recent-body","actions":"table-recent-actions","replacedElement":"table-recent-replace-element"}'>
													</div>
												</th>
												<th class="sort align-middle">שם</th>
												<th class="sort align-middle">ת.ז.</th>
												<th class="sort align-middle">סטטוס</th>
												<? if (WHOLE_INSTITUTION) echo '<th class="sort align-middle">פקולטה</th>'; ?>
											</tr></thead>
											<tbody class="list" id="table-recent-body">
												<? foreach ($students as $student) { ?>
													<tr class="hover-actions-trigger btn-reveal-trigger hover-bg-100">
														<td class="align-middle" style="max-width:30px">
															<div class="form-check mb-0">
																<input name="studentId[]" value="<?=$student['id']?>" class="form-check-input" type="checkbox" data-bulk-select-row="data-bulk-select-row">
															</div>
														</td>
														<td class="align-middle white-space-nowrap name"><?=htmlspecialchars($student['name'])?></td>
														<td class="align-middle white-space-nowrap id"><?=$student['id']?></td>
														<td class="align-middle white-space-nowrap predictedP">
															<?
															switch (true) {
																case $student['predictedP'] <= 0.529:
																	$color = 'success';
																	$label = 'סיכון נמוך';
																	break;
																case $student['predictedP'] <= 0.551:
																	$color = 'warning';
																	$label = 'סיכון בינוני';
																	break;
																default:
																	$color = 'danger';
																	$label = 'סיכון גבוה';
															}
															?>
															<span class="badge fw-semi-bold rounded-pill badge-soft-<?=$color?>"><?=$label?></span>
														</td>
														<? if (WHOLE_INSTITUTION) echo '<td class="align-middle white-space-nowrap facultyName">'.htmlspecialchars($student['facultyName']).'</td>'; ?>
													</tr>
												<? } ?>
											</tbody>
										</table>
										<input type="hidden" name="facultyId" value="<?=$facultyId?>">
									</form>
								</div>
							</div>
						</div>
					</div>
				</div><!-- row -->

				<? require 'inc/footer.inc'; ?>
			</div><!-- content -->
		</div><!-- container -->
	</main>

	<? require 'inc/commonScripts.inc'; ?>
	<script>
		const chartsLabels = ['סיכון גבוה', 'סיכון בינוני', 'סיכון נמוך'],
			chartsBorderColor = [
				'rgba(222, 76, 65, 1)',
				'rgba(240, 200, 66, 1)',
				'rgba(177, 192, 65, 1)'
			],
			/*chartsBgColor = [
				chartsBorderColor[0].replace(/, ?1\)$/, ', 0.8)'),
				chartsBorderColor[1].replace(/, ?1\)$/, ', 0.8)'),
				chartsBorderColor[2].replace(/, ?1\)$/, ', 0.8)')
			],*/
			chartsBgColor = chartsBorderColor,
			chartsData = {<?='"chart'.$facultyId.'": ['.implode(',', array_column($chartsData[$facultyId],'percentage')).'],'?>};
		var myChart;

		for (const id in chartsData) {
			myChart = new Chart(id, {
				type: 'doughnut',
				data: {
					labels: chartsLabels,
					datasets: [{
						data: chartsData[id],
						backgroundColor: chartsBgColor,
						borderColor: chartsBorderColor,
						borderWidth: 1
					}]
				},
				options: {
					interaction: {
						mode: 'point'
					},
					plugins: {
						legend: false
					},
					onClick: (e) => {
						const elements = myChart.getElementsAtEventForMode(e, 'point', {});
						if (elements.length > 0) filterStudentsList(chartsLabels[elements[0].index]);
					},
					onHover: (e) => {
						const elements = myChart.getElementsAtEventForMode(e, 'point', {});
						if (elements.length > 0) e.native.target.style.cursor = 'pointer';
						else e.native.target.style.cursor = 'default';
					}
				}
			});
		}

		function export2XL() {
			var nothingChecked = true;

			for (var i = 0, elements = document.form.elements; i < elements.length; i++) {
				if (elements[i].type == "checkbox" && elements[i].checked) {
					nothingChecked = false;
					break;
				}
			}

			if (nothingChecked) document.getElementById("checkbox-bulk-select").click();
			document.form.submit();
		}

		function filterStudentsList(status) {
			const select = document.getElementById('statusList');
			select.value = status;
			select.dispatchEvent(new Event('change'));
	   	}
	</script>
</body>
</html>