<?
require 'constants.inc';

$inLoginPage = (substr($_SERVER['SCRIPT_NAME'], -10) == '/login.php');

if (isset($_SESSION['loggedIn'])) {
	if (isset($_SESSION['timeout']) && $_SESSION['timeout'] > time()) {
		$_SESSION['timeout'] = time() + TIMEOUT;

		if ($inLoginPage && !isset($_GET['logout'])) redirect('index.php');
	}
	else {
		destroySession();
		redirect('login.php');
	}
}
elseif (!$inLoginPage) redirect('login.php');

register_shutdown_function(function() {
	global $db;
	$db = null;
});
$db = new PDO('mysql:unix_socket='.DB_SOCKET.';dbname='.DB_NAME.';charset=utf8mb4', DB_USER, DB_PASS, [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION, PDO::ATTR_PERSISTENT => true, PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES "utf8mb4" COLLATE "utf8mb4_unicode_520_ci"']);

if (!$inLoginPage) {
	define('FACULTIES', getFaculties());
	define('STUDENTS', getStudents());
}


function destroySession() {
	$_SESSION = [];

	if (ini_get('session.use_cookies')) {
		$params = session_get_cookie_params();
		setcookie(session_name(), '', time() - 42000, $params['path'], $params['domain'], $params['secure'], $params['httponly']);
	}

	session_destroy();
}

function getFaculties($userId = null) {
	$sql = 'SELECT faculties.id,name,icon FROM faculties INNER JOIN icons ON iconId=icons.id ORDER BY name';
	$params = null;

	if ($_SESSION['role'] == 'ראש פקולטה' || !is_null($userId)) {
		$sql = str_replace('FROM faculties', 'FROM faculties INNER JOIN users_faculties ON userId=? AND faculties.id=facultyId', $sql);
		$params = ($_SESSION['role'] == 'ראש פקולטה' ? $_SESSION['loggedIn'] : $userId);
	}

	return queryDB($sql, $params);
}

function getStudents($facultyId = null) {
	if (is_null($facultyId)) {
		$sql = 'SELECT studentsData.id,studentsData.name,predictedP,faculties.id AS facultyId,faculties.name AS facultyName
			FROM studentsData INNER JOIN faculties ON facultyId=faculties.id
			ORDER BY name';
		$params = null;
	}
	else {
		$sql = 'SELECT id,name,predictedP FROM studentsData WHERE facultyId=? ORDER BY name';
		$params = $facultyId;
	}

	return queryDB($sql, $params);
}

function getUserRoles() {
	$roles = queryDB('SELECT COLUMN_TYPE FROM information_schema.COLUMNS WHERE TABLE_SCHEMA="'.DB_NAME.'" AND TABLE_NAME="users" AND COLUMN_NAME="role"')[0]['COLUMN_TYPE'];
	return explode(',', str_replace('\',\'', ',', substr($roles, 6, -2)));
}

function queryDB($statement, $input_parameters = null) {
	global $db;

	if (!is_null($input_parameters) && !is_array($input_parameters)) $input_parameters = [$input_parameters];
	$res = [];

	$stmt = $db->prepare($statement, [PDO::ATTR_CURSOR => PDO::CURSOR_FWDONLY]);
	$stmt->execute($input_parameters);

	do {
		//We must use this loop to catch exceptions in batch statments
		if ($stmt->columnCount() > 0) $res = array_merge($res, $stmt->fetchAll(PDO::FETCH_ASSOC));
	} while ($stmt->nextRowset());

	$stmt->closeCursor();
	return $res;
}

function redirect($url) {
	header('Location: '.$url);
	exit;
}

function showLoginForm() {
	$title = (preg_match('/\/employee\.php$/i', $_SERVER['SCRIPT_NAME']) === 0 ? 'ניהול כספומטים - '.OWNER_NAME : EMPLOYEE_PAGE_TITLE);
	$failedMessage = '';

	if (isset($_SESSION['loginFailed'])) {
		$failedMessage = '<div class="w3-row w3-panel w3-center w3-large w3-text-red">טלפון ו/או סיסמה שגויים</div>';
		unset($_SESSION['loginFailed']);
	}

	echo '<div class="w3-modal w3-show"><div class="w3-modal-content" style="max-width:800px">
		<header class="w3-container w3-light-gray"><h3>'.$title.'</h3></header>
		<form class="w3-container" name="form" action="login.php" method="post">
			'.$failedMessage.'
			<div class="w3-row w3-panel w3-right-align">
				<label>טלפון</label><input class="w3-input w3-border" type="tel" name="phone">
			</div>
			<div class="w3-row w3-panel w3-right-align">
				<label>סיסמה</label><input class="w3-input w3-border" type="password" name="password">
			</div>
			<div class="w3-row w3-panel"></div>

			<div class="w3-row w3-panel w3-center">
				<input class="w3-button w3-large w3-light-gray" type="submit" name="action" value="כניסה">
			</div>

			<input type="hidden" name="return" value="'.$_SERVER['REQUEST_URI'].'">
		</form>
	</div></div>';
}
?>