<? require 'isFluidScript.inc'; ?>

<nav class="navbar navbar-light navbar-vertical navbar-expand-xl">
	<script>
		var navbarStyle = localStorage.getItem('navbarStyle');
		if (navbarStyle && navbarStyle !== 'transparent') {
			document.querySelector('.navbar-vertical').classList.add(`navbar-${navbarStyle}`);
		}
	</script>
	<div class="d-flex align-items-center">
		<div class="toggle-icon-wrapper">
			<button class="btn navbar-toggler-humburger-icon navbar-vertical-toggle" data-bs-toggle="tooltip" data-bs-placement="left" title="הסתר/הצג תפריט"><span class="navbar-toggle-icon"><span class="toggle-line"></span></span></button>
		</div>
		<a class="navbar-brand" href="index.php">
			<div class="d-flex align-items-center py-3">
				<img class="me-2" src="assets/img/logo.png" alt="" width="40"><span class="font-sans-serif"><?=APP_NAME?></span>
			</div>
		</a>
	</div>
	<div class="collapse navbar-collapse" id="navbarVerticalCollapse">
		<div class="navbar-vertical-content scrollbar">
			<ul class="navbar-nav flex-column mb-3" id="navbarVerticalNav">
				<li class="nav-item">
					<a class="nav-link" href="index.php" role="button" data-bs-toggle="" aria-expanded="false">
						<div class="d-flex align-items-center">
							<span class="nav-link-icon"><span class="fas fa-home"></span></span><span class="nav-link-text ps-1">ראשי</span>
						</div>
					</a>
					<? if ($_SESSION['role'] == 'אדמין') { ?>
						<a class="nav-link dropdown-indicator" href="#users" role="button" data-bs-toggle="collapse" aria-expanded="false" aria-controls="users">
							<div class="d-flex align-items-center">
								<span class="nav-link-icon"><span class="fas fa-user"></span></span><span class="nav-link-text ps-1">ניהול משתמשים</span>
							</div>
						</a>
						<ul class="nav collapse" id="users"><?
							(function() {
								foreach (queryDB('SELECT id,CONCAT(fname," ",lname) AS fullname FROM users ORDER BY CASE role WHEN "אדמין" THEN 0 WHEN "ראש פקולטה" THEN 1 ELSE 2 END,fname,lname') as $user) {
									?><li class="nav-item">
										<a class="nav-link" href="user.php?id=<?=$user['id']?>" data-bs-toggle="" aria-expanded="false">
											<div class="d-flex align-items-center">
												<span class="nav-link-text ps-1"><?=htmlspecialchars($user['fullname'])?></span>
											</div>
										</a>
									</li><?
								}

								?><li class="nav-item">
									<a class="nav-link mt-2" role="button" data-bs-toggle="modal" data-bs-target="#addUserModal" aria-expanded="false">
										<div class="d-flex align-items-center">
											<span class="nav-link-icon"><span class="fas fa-plus"></span></span><span class="nav-link-text ps-1">הוספת משתמש</span>
										</div>
									</a>
								</li><?
							})();
						?></ul>
					<? } ?>
				</li>
				<li class="nav-item">
					<div class="row navbar-vertical-label-wrapper mt-3 mb-2">
						<div class="col-auto navbar-vertical-label">פקולטות</div>
						<div class="col ps-0">
							<hr class="mb-0 navbar-vertical-divider">
						</div>
					</div>

					<?
					(function() {
						foreach (FACULTIES as $faculty) {
							?><a class="nav-link" href="faculty.php?id=<?=$faculty['id']?>" role="button" data-bs-toggle="" aria-expanded="false">
								<div class="d-flex align-items-center">
									<span class="nav-link-icon"><span class="<?=$faculty['icon']?>"></span></span>
									<span class="nav-link-text ps-1"><?=htmlspecialchars($faculty['name'])?></span>
									<? if ($_SESSION['role'] == 'אדמין') echo '<span class="nav-link-icon ms-auto deleteFaculty" role="button" data-bs-toggle="modal" data-bs-target="#deleteFacultyModal"
										onclick="return deleteFaculty('.$faculty['id'].',\''.htmlspecialchars($faculty['name']).'\')"><span class="far fa-trash-alt"></span></span>'; ?>
								</div>
							</a><?
						}
					})();
					?>

					<? if ($_SESSION['role'] == 'אדמין') { ?>
						<a class="nav-link mt-3" role="button" data-bs-toggle="modal" data-bs-target="#addFacultyModal" aria-expanded="false">
							<div class="d-flex align-items-center">
								<span class="nav-link-icon"><span class="fas fa-plus"></span></span><span class="nav-link-text ps-1">הוספת פקולטה</span>
							</div>
						</a>
					<? } ?>
				</li>
			</ul>
		</div>
	</div>
</nav>