<?
require 'inc/functions.inc';

$chartsData = [];
?>
<!DOCTYPE html>
<html>
<head>
	<? require 'inc/commonHead.inc'; ?>
	<title><?=APP_NAME?></title>
</head>

<body>
	<main class="main" id="top">
		<div class="container" data-layout="container">
			<? require 'inc/menu.inc'; ?>

			<div class="content">
				<? require 'inc/searchBar.inc'; ?>

				<div class="row mb-4"><?
					//Prepend an element to the faculties array to represent the whole institution
					$faculties = FACULTIES;
					array_unshift($faculties, WHOLE_INSTITUTION_FACULTY);

					foreach ($faculties as $faculty) {
						if ($faculty['id'] != 0) {
							$whereCriterion = ' WHERE facultyId=?';
							$params = [$faculty['id'], $faculty['id']];
						}
						else {
							$whereCriterion = '';
							$params = null;
						}
						$chartsData[$faculty['id']] = queryDB('SELECT CASE WHEN predictedP<=0.529 THEN "3 סיכון נמוך" WHEN predictedP<=0.551 THEN "2 סיכון בינוני" ELSE "1 סיכון גבוה" END AS riskGroup,
								ROUND(COUNT(0)/(SELECT COUNT(0) AS `count` FROM studentsData'.$whereCriterion.')*100,1) AS percentage
							FROM studentsData'.$whereCriterion.'
							GROUP BY riskGroup ORDER BY riskGroup', $params);

						?><div class="col-3 px-2 mb-3">
							<div class="card cursor-pointer" onclick="location.href='faculty.php?id=<?=$faculty['id']?>'">
								<div class="card-header">
									<span class="<?=$faculty['icon']?>"></span> <?=htmlspecialchars($faculty['name'])?>
								</div>
								<div class="card-body overflow-hidden p-lg-4">
									<canvas id="chart<?=$faculty['id']?>"></canvas>
									<?
									foreach ($chartsData[$faculty['id']] as $chartData) {
										$riskGroup = substr($chartData['riskGroup'], 2);
										// TODO: set this with periodical data
										$change = '<span class="fas '.(rand(0,99) < 50 ? 'fa-caret-down text-danger' : 'fa-caret-up text-success').'"></span> '.rand(1,200).'%';

										echo '<div class="row border-top py-2'.($riskGroup == 'סיכון גבוה' ? ' mt-4' : ($riskGroup == 'סיכון נמוך' ? ' mb-n3' : '')).'">
												<div class="col px-2">'.$riskGroup.'</div>
												<div class="col px-2">'.$chartData['percentage'].'%</div>
												<div class="col px-2">'.$change.'</div>
											</div>';
									}
									?>
								</div>
							</div>
						</div><?
					}
				?></div><!-- row -->

<!--<div class="gradientSeparatorB" style="width:100vw; background-color:red; height:8px; margin-bottom:14px; z-index:2000; position:sticky;"></div>
<script>
var marginRight = -Math.round(window.innerWidth - document.querySelector(".gradientSeparatorB").getBoundingClientRect().right);
document.querySelector(".gradientSeparatorB").style.marginRight = marginRight+"px";
//document.querySelector(".gradientSeparatorB").style.top = document.querySelector(".gradientSeparatorB").getBoundingClientRect().top+"px";
/*console.log(window.innerWidth);
console.log(document.querySelector(".gradientSeparatorB").getBoundingClientRect());
console.log(window.innerWidth - document.documentElement.clientWidth);*/
</script>-->

				<? require 'inc/footer.inc'; ?>
			</div><!-- content -->
		</div><!-- container -->
	</main>
						<div class="modal fade" id="addFacModal" tabindex="-1" role="dialog" aria-hidden="true">
							<div class="modal-dialog modal-dialog-centered" role="document" style="max-width:500px">
								<div class="modal-content position-relative">
									<div class="position-absolute top-0 end-0 mt-2 me-2 z-index-1">
										<button class="btn-close btn btn-sm btn-circle d-flex flex-center transition-base" data-bs-dismiss="modal" aria-label="Close"></button>
									</div>
									<div class="modal-body p-0">
										<div class="rounded-top-lg py-3 ps-4 pe-6 bg-light">
											<h4 class="mb-1" id="modalExampleDemoLabel">Add a new illustration </h4>
										</div>
										<div class="p-4 pb-0">
											<form>
												<div class="mb-3">
													<label class="col-form-label" for="recipient-name">Recipient:</label>
													<input class="form-control" id="recipient-name" type="text" />
												</div>
												<div class="mb-3">
													<label class="col-form-label" for="message-text">Message:</label>
													<textarea class="form-control" id="message-text"></textarea>
												</div>
											</form>
										</div>
									</div>
									<div class="modal-footer">
										<button class="btn btn-secondary" type="button" data-bs-dismiss="modal">Close</button>
										<button class="btn btn-primary" type="button">Understood </button>
									</div>
								</div>
							</div>
						</div>

	<? require 'inc/commonScripts.inc'; ?>
	<script>
		const chartsLabels = ['סיכון גבוה', 'סיכון בינוני', 'סיכון נמוך'],
			chartsBorderColor = [
				getComputedStyle(document.documentElement).getPropertyValue('--falcon-badge-soft-danger-color'),
				getComputedStyle(document.documentElement).getPropertyValue('--falcon-badge-soft-warning-color'),
				getComputedStyle(document.documentElement).getPropertyValue('--falcon-badge-soft-success-color')
			],
			/*chartsBgColor = [
				chartsBorderColor[0].replace(/, ?1\)$/, ', 0.8)'),
				chartsBorderColor[1].replace(/, ?1\)$/, ', 0.8)'),
				chartsBorderColor[2].replace(/, ?1\)$/, ', 0.8)')
			],*/
			chartsBgColor = chartsBorderColor,
			chartsData = {<?
				foreach ($chartsData as $facultyId=>$chartData)
					echo '"chart'.$facultyId.'": ['.implode(',', array_column($chartData,'percentage')).'],';
			?>};

		for (const id in chartsData) {
			new Chart(id, {
				type: 'doughnut',
				data: {
					labels: chartsLabels,
					datasets: [{
						data: chartsData[id],
						backgroundColor: chartsBgColor,
						borderColor: chartsBorderColor,
						borderWidth: 1
					}]
				},
				options: {
					plugins: {
						legend: false
					}
				}
			});
		}
</script>
</body>
</html>