<?
require 'inc/functions.inc';

if (isset($_POST['login'])) {
	$email = trim($_POST['email']);
	$password = trim($_POST['password']);

	$statusMsg = 'מייל או סיסמה לא נכונים';

	$rs = queryDB('SELECT id,fname,lname,role,password FROM users WHERE email=?', $email);
	if (count($rs) == 1) {
		$rs = $rs[0];
		if (password_verify($password, $rs['password'])) {
			if (password_needs_rehash($rs['password'], PASSWORD_DEFAULT))
				queryDB('UPDATE users SET password=? WHERE id=?', [password_hash($password, PASSWORD_DEFAULT), $rs['id']]);

			$_SESSION = [
				'role' => $rs['role'],
				'loggedIn' => $rs['id'],
				'name' => $rs['fname'].' '.$rs['lname'],
				'timeout' => time() + TIMEOUT
			];

			redirect('index.php');
		}
	}
}
elseif (isset($_GET['logout'])) {
	destroySession();
	redirect('login.php');
}
?>
<!DOCTYPE html>
<html>
<head>
	<? require 'inc/commonHead.inc'; ?>
	<title>התחברות | <?=APP_NAME?></title>
</head>
<body>
	<main class="main" id="top">
		<div class="container" data-layout="container">
			<? require 'inc/isFluidScript.inc'; ?>

			<div class="row flex-center min-vh-100 py-6">
				<div class="col-sm-10 col-md-8 col-lg-6 col-xl-5 col-xxl-4 mb-4">
					<div class="d-flex flex-center mb-4">
						<img class="me-2" src="assets/img/logo.png" alt="" width="58">
						<span class="font-sans-serif fw-bolder fs-5 d-inline-block"><?=APP_NAME?></span>
					</div>

					<div class="card">
						<div class="card-body p-4 p-sm-5">
							<? if (isset($statusMsg)) { ?>
								<div class="alert alert-danger border-2 d-flex align-items-center" role="alert">
									<div class="bg-danger me-3 icon-item"><span class="fas fa-times-circle text-white fs-3"></span></div>
									<p class="mb-0 flex-1"><?=$statusMsg?></p>
								</div>
							<? } ?>

							<div class="row flex-between-center mb-2">
								<div class="col-auto">
									<h5>התחברות</h5>
								</div>
								<!--<div class="col-auto fs--1 text-600"><span class="mb-0 undefined">or</span> <span><a href="../../../pages/authentication/simple/register.html">Create an account</a></span></div>-->
							</div>
							<form method="post" class="needs-validation" novalidate>
								<div class="mb-3">
									<input class="form-control" name="email" type="email" placeholder="מייל" required>
								</div>
								<div class="mb-3">
									<input class="form-control" name="password" type="password" placeholder="סיסמה" required>
								</div>
								<!--<div class="row flex-between-center">
									<div class="col-auto">
										<div class="form-check mb-0">
											<input class="form-check-input" name="remember" type="checkbox" id="basic-checkbox" checked>
											<label class="form-check-label mb-0" for="basic-checkbox">זכור אותי</label>
										</div>
									</div>
									<div class="col-auto"><a class="fs--1" href="../../../pages/authentication/simple/forgot-password.html">שכחת סיסמה?</a></div>
								</div>-->
								<div class="mb-3">
									<button class="btn btn-primary d-block w-100 mt-3" type="submit" name="login">התחבר</button>
								</div>
							</form>
							<!--<div class="position-relative mt-4">
								<hr class="bg-300">
								<div class="divider-content-center">or log in with</div>
							</div>
							<div class="row g-2 mt-2">
								<div class="col-sm-6"><a class="btn btn-outline-google-plus btn-sm d-block w-100" href="#"><span class="fab fa-google-plus-g me-2" data-fa-transform="grow-8"></span> google</a></div>
								<div class="col-sm-6"><a class="btn btn-outline-facebook btn-sm d-block w-100" href="#"><span class="fab fa-facebook-square me-2" data-fa-transform="grow-8"></span> facebook</a></div>
							</div>-->
						</div>
					</div>
				</div>

				<? require 'inc/footer.inc'; ?>
			</div><!-- row -->
		</div><!-- container -->
	</main>

	<? require 'inc/commonScripts.inc'; ?>
</body>
</html>