<?
require '../inc/functions.inc';
require '../lib/PHPExcel.php';

define('WHOLE_INSTITUTION', $_POST['facultyId'] == 0);

$listHeaders = ['שם', 'ת.ז.', 'סטטוס'];
$sql = 'SELECT studentsData.name,studentsData.id,
	CASE WHEN predictedP<=0.529 THEN "סיכון נמוך" WHEN predictedP<=0.551 THEN "סיכון בינוני" ELSE "סיכון גבוה" END AS riskGroup
	FROM studentsData ORDER BY studentsData.name';

if (!WHOLE_INSTITUTION) {
	$sql = str_replace('FROM studentsData ', 'FROM studentsData WHERE facultyId=? ', $sql);
	$params = $_POST['facultyId'];
}
else {
	$listHeaders[] = 'פקולטה';
	$sql = str_replace('FROM studentsData ', ',faculties.name AS facultyName FROM studentsData INNER JOIN faculties ON facultyId=faculties.id ', $sql);
	$params = null;
}

if (isset($_POST['studentId'])) {
	$ids = preg_replace('/[^0-9,]/', '', implode(',', $_POST['studentId']));
	if (!WHOLE_INSTITUTION) $sql = str_replace('WHERE ', 'WHERE studentsData.id IN ('.$ids.') AND ', $sql);
	else $sql = str_replace('ORDER BY ', 'WHERE studentsData.id IN ('.$ids.') ORDER BY ', $sql);
}

$students = queryDB($sql, $params);

$phpExcel = new PHPExcel();
$defaultStyle = $phpExcel->getDefaultStyle();
$defaultStyle->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
$defaultStyle->getFont()->setName('Arial');
$defaultStyle->getFont()->setSize(11);

$sheet = $phpExcel->getActiveSheet();
$sheet->fromArray($listHeaders)
	->fromArray(
        $students,	// The data to set
        NULL,		// Array values with this value will not be set
        'A2'		// Top left coordinate of the worksheet range where we want to set these values (default is A1)
    )
	->setRightToLeft(true)
	->setTitle('גיליון1');

for ($col = 0; $col < count($listHeaders); $col++) {
	$cell = $sheet->getCellByColumnAndRow($col, 1);
	$style = $cell->getStyle();
	$style->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	$style->getFont()->setBold(true);
	$sheet->getColumnDimension($cell->getColumn())->setAutoSize(true);
}

for ($row = 1, $highestRow = $sheet->getHighestRow(); $row <= $highestRow; $row++) {
	$cell = $sheet->getCellByColumnAndRow(0, $row);
	$cell->setValueExplicit($cell->getValue(), PHPExcel_Cell_DataType::TYPE_STRING);
}

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="export'.time().'.xlsx"');
header('Cache-Control: max-age=0');

// If you're serving to IE 9, then the following may be needed
//header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
/*
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0
*/

PHPExcel_IOFactory::createWriter($phpExcel, 'Excel2007')->save('php://output');
?>