<?
require 'inc/functions.inc';

$userId = trim($_GET['id']);
$user = queryDB('SELECT fname,lname,role,email FROM users WHERE id=?', $userId)[0];
$user['faculties'] = array_column(getFaculties($userId), 'id');

$roles = '';
foreach (getUserRoles() as $role) $roles .= '<option value="'.htmlspecialchars($role).'">'.htmlspecialchars($role).'</option>';
$roles = str_replace(' value="'.htmlspecialchars($user['role']).'"', ' value="'.htmlspecialchars($user['role']).'" selected', $roles);
?>
<!DOCTYPE html>
<html>
<head>
	<? require 'inc/commonHead.inc'; ?>
	<title>הגדרות משתמש | <?=APP_NAME?></title>
</head>
<body>
	<main class="main" id="top">
		<div class="container" data-layout="container">
			<? require 'inc/menu.inc'; ?>

			<div class="content">
				<? require 'inc/searchBar.inc'; ?>

				<div class="row g-0 mb-4">
					<div class="col-lg-8 pe-lg-2">
						<div class="card mb-3">
							<div class="card-header">
								<h5 class="mb-0">הגדרות משתמש</h5>
							</div>
							<div class="card-body bg-light">
								<form class="row g-3 needs-validation" action="model/users.php" method="post" novalidate>
									<div class="col-lg-6">
										<label class="form-label" for="first-name">שם פרטי</label>
										<input class="form-control" id="first-name" type="text" name="fname" value="<?=htmlspecialchars($user['fname'])?>" required>
									</div>
									<div class="col-lg-6">
										<label class="form-label" for="last-name">שם משפחה</label>
										<input class="form-control" id="last-name" type="text" name="lname" value="<?=htmlspecialchars($user['lname'])?>" required>
									</div>
									<div class="col-lg-6">
										<label class="form-label" for="role">תפקיד</label>
										<select class="form-select" id="role" name="role"><?=$roles?></select>
									</div>
									<div class="col-lg-6">
										<label class="form-label" for="email">מייל</label>
										<input class="form-control" id="email" type="text" name="email" value="<?=htmlspecialchars($user['email'])?>" required>
									</div>
									<div class="col-12 d-flex justify-content-end">
										<button class="btn btn-primary" type="submit">שמור</button>
									</div>
									<input type="hidden" name="id" value="<?=$userId?>">
									<input type="hidden" name="action" value="update">
								</form>
							</div>
						</div>

						<div class="card mb-3">
							<div class="card-header">
								<h5 class="mb-0">פקולטות מורשות</h5>
							</div>
							<div class="card-body bg-light">
								<form action="model/users.php" method="post">
									<div class="table-responsive scrollbar">
										<table class="table fs--1 mb-0">
											<thead class="bg-200 text-800"><tr>
												<th class="py-3 white-space-nowrap" style="max-width:30px">
													<div class="form-check mb-0 d-flex align-items-center">
														<input class="form-check-input" id="checkbox-bulk-select" type="checkbox" data-bulk-select='{"body":"table-recent-body","actions":"table-recent-actions","replacedElement":"table-recent-replace-element"}'>
													</div>
												</th>
												<th class="sort align-middle">מזהה</th>
												<th class="sort align-middle">שם</th>
											</tr></thead>
											<tbody class="list" id="table-recent-body">
												<? foreach (FACULTIES as $faculty) { ?>
													<tr class="hover-actions-trigger btn-reveal-trigger hover-bg-100">
														<td class="align-middle" style="max-width:30px">
															<div class="form-check mb-0">
																<input name="faculties[]" value="<?=$faculty['id']?>" class="form-check-input" type="checkbox" data-bulk-select-row="data-bulk-select-row"
																	<? if (in_array($faculty['id'], $user['faculties'])) echo 'checked';?>>
															</div>
														</td>
														<td class="align-middle white-space-nowrap id"><?=$faculty['id']?></td>
														<td class="align-middle white-space-nowrap name">
															<span class="<?=$faculty['icon']?> me-1"></span>
															<?=htmlspecialchars($faculty['name'])?>
														</td>
													</tr>
												<? } ?>
											</tbody>
										</table>
									</div>
									<div class="col-12 d-flex justify-content-end mt-3">
										<button class="btn btn-primary" type="submit">שמור</button>
									</div>
									<input type="hidden" name="id" value="<?=$userId?>">
									<input type="hidden" name="action" value="setFaculties">
								</form>
							</div>
						</div>
					</div><!-- right column -->

					<div class="col-lg-4 ps-lg-2">
						<div class="sticky-sidebar" style="top:4.313rem">
							<div class="card mb-3">
								<div class="card-header">
									<h5 class="mb-0">שינוי סיסמה</h5>
								</div>
								<div class="card-body bg-light">
									<form action="model/users.php" method="post" class="needs-validation" novalidate>
										<div class="mb-3">
											<label class="form-label" for="old-password">סיסמה ישנה</label>
											<input class="form-control" id="old-password" type="password" name="oldPassword" required>
										</div>
										<div class="mb-3">
											<label class="form-label" for="new-password">סיסמה חדשה</label>
											<input class="form-control" id="new-password" type="password" name="newPassword" required>
										</div>
										<div class="mb-3">
											<label class="form-label" for="confirm-password">אישור סיסמה</label>
											<input class="form-control" id="confirm-password" type="password" name="newPassword2" required>
										</div>
										<button class="btn btn-primary d-block w-100" type="submit">שמור</button>
										<input type="hidden" name="id" value="<?=$userId?>">
										<input type="hidden" name="action" value="changePassword">
									</form>
								</div>
							</div>

							<div class="card">
								<div class="card-header">
									<h5 class="mb-0">מחיקת משתמש</h5>
								</div>
								<div class="card-body bg-light">
									<!--<h5 class="fs-0">Delete this account</h5>-->
									<p class="fs--1"><b>שים לב:</b> פעולה זו תביא למחיקת המשתמש מהמערכת לחלוטין והיא אינה ניתנת לביטול.</p>
									<a class="btn btn-falcon-danger d-block w-100" role="button" data-bs-toggle="modal" data-bs-target="#deleteUserModal"
										onclick="return deleteUser(<?=$userId?>,'<?=htmlspecialchars($user['fname'].' '.$user['lname'])?>')">מחיקת משתמש</a>
								</div>
							</div>
						</div>
					</div><!-- left column -->
				</div><!-- row -->

				<? require 'inc/footer.inc'; ?>
			</div><!-- content -->
		</div><!-- container -->
	</main>

	<? require 'inc/commonScripts.inc'; ?>
</body>
</html>